############### ###############
## T_H1_Familiarity
## Project: CBO
## Contributors: Kamil Kouhen, Malte Lierl
## Date of creation: 23/06/2022
############### ###############

# A_DM_know_and_inter --------------- ###### 

  ### List of respondent type
  toestimate <- c("Mayor", "Deputy Mayor", "Opposition Member", "Secretary General")
  
  ## a. Pooled estimation across respondent types ####
  
  H1.familiarity.all <- lm_robust(A_DM_know_and_inter ~ treatmentcommune + 
       factor(respondent_type), #Controlling for respondent type
     data = DM_finalx2,
     #weights = DM_weight, # re-weighting, so that municipalities receive equal weight
     clusters=appcode, # CBO id
     fixed_effect=factor(randomization_block))  %>% summary()
  H1.familiarity.all
  
  ## b. Mayors ####
  
  H1.familiarity.mayor <- lm_robust(A_DM_know_and_inter ~ treatmentcommune, 
                                  data = DM_finalx2 %>% filter(respondent_type=="Mayor"),     
                                  fixed_effect=factor(randomization_block), se_type="HC3")  %>% summary()
  H1.familiarity.mayor
  
  ## c. Deputy mayors ####
  
  H1.familiarity.deputy <- lm_robust(A_DM_know_and_inter ~ treatmentcommune, 
                                    data = DM_finalx2 %>% filter(respondent_type=="Deputy Mayor"),     
                                    fixed_effect=factor(randomization_block), se_type="HC3")  %>% summary()
  H1.familiarity.deputy
  
  ## d. Opposition leaders ####
  
  H1.familiarity.opposition <- lm_robust(A_DM_know_and_inter ~ treatmentcommune, 
                                     data = DM_finalx2 %>% filter(respondent_type=="Opposition Member"),     
                                     fixed_effect=factor(randomization_block), se_type="HC3")  %>% summary()
  H1.familiarity.opposition
  
  ## e. Secretary-generals ####
  
  H1.familiarity.sg <- lm_robust(A_DM_know_and_inter ~ treatmentcommune, 
                                         data = DM_finalx2 %>% filter(respondent_type=="Secretary General"),     
                                         fixed_effect=factor(randomization_block), se_type="HC3") %>% summary()
  H1.familiarity.sg
  
  
  ## f. Calculating control group means ####
  # covariates <- c(", respondent_type")
  # tab_salience$control.group.mean <- 
  #   c(
  #     round(eval(parse(text = paste0(
  #       "mean(
  #         (DM_finalx2 %>% 
  #           filter(treatmentcommune == 0) %>%
  #           drop_na(A_DM_know_and_inter", covariates, "))$A_DM_know_and_inter
  #           )"))), digits = 2),
  #     sapply(toestimate, function(restype){
  #       round(eval(parse(text = paste0(
  #         "mean(
  #         (DM_finalx2 %>% 
  #           filter(treatmentcommune == 0) %>%
  #           drop_na(A_DM_know_and_inter", covariates, ") %>%
  #           filter(respondent_type =='", restype, "'))$A_DM_know_and_inter
  #           )"))), digits = 2)
  #     })
  #   )
  # 
  # Function to output control group mean
  cgmean <- function(x, digits=3) {
    cg <- x %>% filter(treatmentcommune==0) %>%  drop_na(A_DM_know_and_inter) 
    signif(mean(cg$A_DM_know_and_inter, na.rm=TRUE), digits=digits)
  }
  
  ## g. Number of clusters in H1.familiarity.all ####
  clustersn <- DM_finalx2 %>% drop_na(A_DM_know_and_inter) %>% distinct(appcode) %>% nrow
  
  ## h. Output table
    tex("
        \\begin{tabularx}{\\textwidth}{l X X X X X}
        \\hline
        & \\multicolumn{5}{c}{\\emph{DV: Awareness of and interaction with CBOs}}\\\\
        & \\multicolumn{5}{c}{\\emph{0 = Has never heard about CBO ... 4 = Has personally been approached by the CBO}}\\\\

        \\\\
        & (1) & (2) & (3) & (4) & (5) \\\\
        &  All & Mayors & Deputy Mayors & Opposition Leaders & Secretary General\\\\
        \\hline 
        \\\\
        Control group mean & <<cgmean(DM_finalx2)>> & <<cgmean(DM_finalx2 %>% filter(respondent_type=='Mayor'))>> & <<cgmean(DM_finalx2 %>% filter(respondent_type=='Deputy Mayor'))>> & <<cgmean(DM_finalx2 %>% filter(respondent_type=='Opposition Member'))>> & <<cgmean(DM_finalx2 %>% filter(respondent_type=='Secretary General'))>> \\\\
        \\\\
        Average Treatment Effect & <<stars(H1.familiarity.all, 'treatmentcommune', digits=3)>> & <<stars(H1.familiarity.mayor, 'treatmentcommune', digits=3)>> & <<stars(H1.familiarity.deputy, 'treatmentcommune', digits=3)>> & <<stars(H1.familiarity.opposition, 'treatmentcommune', digits=3)>> & <<stars(H1.familiarity.sg, 'treatmentcommune', digits=3)>> \\\\
                                 & <<se(H1.familiarity.all, 'treatmentcommune', digits=3)>> & <<se(H1.familiarity.mayor, 'treatmentcommune', digits=3)>> & <<se(H1.familiarity.deputy, 'treatmentcommune', digits=3)>> & <<se(H1.familiarity.opposition, 'treatmentcommune', digits=3)>> & <<se(H1.familiarity.sg, 'treatmentcommune', digits=3)>> \\\\
        \\\\
        \\hline
        Observations & <<H1.familiarity.all$nobs>> & <<H1.familiarity.mayor$nobs>> & <<H1.familiarity.deputy$nobs>> & <<H1.familiarity.opposition$nobs>> & <<H1.familiarity.sg$nobs>> \\\\
        Clusters (CBOs) & <<clustersn>>  & & & & \\\\
        \\hline \\hline
        \\end{tabularx}
        \\footnotesize{Coefficients from OLS regressions with fixed effects for randomization blocks. Column (1): Cluster-robust standard errors in parentheses. Columns (2)-(5): HC3 standard errors in parentheses. $^{*} p<0.1$, $^{**} p<0.05$, $^{***} p<0.01$ (two-sided).}
                    ", 
                  file = here('Output/For Publication/Tables/T_H1_Familiarity.tex'))

  rm(clustersn)



